-- ============================================================
-- রমযান বাড়ি — MySQL Database Setup
-- phpMyAdmin এ এই SQL টি run করুন
-- ============================================================

CREATE DATABASE IF NOT EXISTS ramadan_db CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
USE ramadan_db;

-- নামাজের সময় টেবিল
CREATE TABLE IF NOT EXISTS prayers (
  id INT AUTO_INCREMENT PRIMARY KEY,
  prayer_key VARCHAR(20) NOT NULL UNIQUE,
  prayer_name VARCHAR(50) NOT NULL,
  prayer_time VARCHAR(20) NOT NULL,
  updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- রমযান সময়সূচী টেবিল
CREATE TABLE IF NOT EXISTS schedule (
  id INT AUTO_INCREMENT PRIMARY KEY,
  ramadan_day INT NOT NULL UNIQUE,
  day_name VARCHAR(20) NOT NULL,
  hijri_date VARCHAR(30) NOT NULL,
  sahri_time VARCHAR(20) NOT NULL,
  fajr_time VARCHAR(20) NOT NULL,
  iftar_time VARCHAR(20) NOT NULL,
  updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- দোয়া টেবিল
CREATE TABLE IF NOT EXISTS duas (
  id INT AUTO_INCREMENT PRIMARY KEY,
  title VARCHAR(100) NOT NULL,
  arabic_text TEXT NOT NULL,
  bangla_translation TEXT NOT NULL,
  has_audio TINYINT(1) DEFAULT 0,
  sort_order INT DEFAULT 0,
  updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- হাদীস টেবিল
CREATE TABLE IF NOT EXISTS hadith (
  id INT AUTO_INCREMENT PRIMARY KEY,
  arabic_text TEXT NOT NULL,
  bangla_translation TEXT NOT NULL,
  source VARCHAR(100) NOT NULL,
  is_active TINYINT(1) DEFAULT 1,
  updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- লোকেশন টেবিল
CREATE TABLE IF NOT EXISTS locations (
  id INT AUTO_INCREMENT PRIMARY KEY,
  city VARCHAR(50) NOT NULL,
  country_code VARCHAR(5) NOT NULL,
  latitude DECIMAL(10,6) NOT NULL,
  longitude DECIMAL(10,6) NOT NULL,
  calc_method INT DEFAULT 3,
  is_default TINYINT(1) DEFAULT 0,
  updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- অ্যাডমিন টেবিল
CREATE TABLE IF NOT EXISTS admin_users (
  id INT AUTO_INCREMENT PRIMARY KEY,
  username VARCHAR(50) NOT NULL UNIQUE,
  password_hash VARCHAR(255) NOT NULL,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- ============================================================
-- DEFAULT DATA INSERT
-- ============================================================

-- নামাজের সময় (default)
INSERT INTO prayers (prayer_key, prayer_name, prayer_time) VALUES
('Sahri',   'সাহরীর শেষ',      '6:19 AM'),
('Fajr',    'ফজর',             '6:29 AM'),
('Sunrise', 'সূর্যোদয়',        '7:27 AM'),
('Dhuhr',   'যোহর',            '1:28 PM'),
('Asr',     'আসর',             '4:45 PM'),
('Maghrib', 'মাগরিব (ইফতার)',  '7:29 PM'),
('Isha',    'ইশা',             '8:27 PM')
ON DUPLICATE KEY UPDATE prayer_time = VALUES(prayer_time);

-- রমযান ২০২৬ সময়সূচী
INSERT INTO schedule (ramadan_day, day_name, hijri_date, sahri_time, fajr_time, iftar_time) VALUES
(1,  'Thursday',  '19 Feb 2026', '6:20 AM', '6:30 AM', '7:29 PM'),
(2,  'Friday',    '20 Feb 2026', '6:19 AM', '6:29 AM', '7:29 PM'),
(3,  'Saturday',  '21 Feb 2026', '6:19 AM', '6:29 AM', '7:29 PM'),
(4,  'Sunday',    '22 Feb 2026', '6:19 AM', '6:29 AM', '7:29 PM'),
(5,  'Monday',    '23 Feb 2026', '6:19 AM', '6:29 AM', '7:29 PM'),
(6,  'Tuesday',   '24 Feb 2026', '6:19 AM', '6:29 AM', '7:29 PM'),
(7,  'Wednesday', '25 Feb 2026', '6:19 AM', '6:29 AM', '7:29 PM'),
(8,  'Thursday',  '26 Feb 2026', '6:19 AM', '6:29 AM', '7:29 PM'),
(9,  'Friday',    '27 Feb 2026', '6:18 AM', '6:28 AM', '7:29 PM'),
(10, 'Saturday',  '28 Feb 2026', '6:18 AM', '6:28 AM', '7:29 PM'),
(11, 'Sunday',    '01 Mar 2026', '6:18 AM', '6:28 AM', '7:28 PM'),
(12, 'Monday',    '02 Mar 2026', '6:18 AM', '6:28 AM', '7:28 PM'),
(13, 'Tuesday',   '03 Mar 2026', '6:17 AM', '6:27 AM', '7:28 PM'),
(14, 'Wednesday', '04 Mar 2026', '6:17 AM', '6:27 AM', '7:27 PM'),
(15, 'Thursday',  '05 Mar 2026', '6:17 AM', '6:27 AM', '7:27 PM'),
(16, 'Friday',    '06 Mar 2026', '6:17 AM', '6:27 AM', '7:27 PM'),
(17, 'Saturday',  '07 Mar 2026', '6:16 AM', '6:26 AM', '7:27 PM'),
(18, 'Sunday',    '08 Mar 2026', '6:16 AM', '6:26 AM', '7:27 PM'),
(19, 'Monday',    '09 Mar 2026', '6:16 AM', '6:26 AM', '7:27 PM'),
(20, 'Tuesday',   '10 Mar 2026', '6:15 AM', '6:25 AM', '7:27 PM'),
(21, 'Wednesday', '11 Mar 2026', '6:15 AM', '6:25 AM', '7:27 PM'),
(22, 'Thursday',  '12 Mar 2026', '6:15 AM', '6:25 AM', '7:27 PM'),
(23, 'Friday',    '13 Mar 2026', '6:15 AM', '6:25 AM', '7:27 PM'),
(24, 'Saturday',  '14 Mar 2026', '6:14 AM', '6:24 AM', '7:26 PM'),
(25, 'Sunday',    '15 Mar 2026', '6:14 AM', '6:24 AM', '7:26 PM'),
(26, 'Monday',    '16 Mar 2026', '6:13 AM', '6:23 AM', '7:26 PM'),
(27, 'Tuesday',   '17 Mar 2026', '6:13 AM', '6:23 AM', '7:26 PM'),
(28, 'Wednesday', '18 Mar 2026', '6:12 AM', '6:22 AM', '7:25 PM'),
(29, 'Thursday',  '19 Mar 2026', '6:12 AM', '6:22 AM', '7:25 PM'),
(30, 'Friday',    '20 Mar 2026', '6:12 AM', '6:22 AM', '7:25 PM')
ON DUPLICATE KEY UPDATE day_name=VALUES(day_name), hijri_date=VALUES(hijri_date),
sahri_time=VALUES(sahri_time), fajr_time=VALUES(fajr_time), iftar_time=VALUES(iftar_time);

-- দোয়া
INSERT INTO duas (title, arabic_text, bangla_translation, has_audio, sort_order) VALUES
('সাহরীর দোয়া', 'وَبِصَوْمِ غَدٍ نَوَيْتُ مِنْ شَهْرِ رَمَضَانَ', 'আমি আগামীকালের রোজা রাখার নিয়ত করলাম রমযান মাসের।', 1, 1),
('ইফতারের দোয়া', 'اللَّهُمَّ إِنِّي لَكَ صُمْتُ وَبِكَ آمَنْتُ وَعَلَيْكَ تَوَكَّلْتُ وَعَلَى رِزْقِكَ أَفْطَرْتُ', 'হে আল্লাহ! আমি তোমারই সন্তুষ্টির জন্যে রোযা রেখেছি এবং তোমার প্রতি ঈমান রেখেছি এবং তোমার উপরই ভরসা করেছি।', 0, 2),
('লাইলাতুল কদরের দোয়া', 'اللَّهُمَّ إِنَّكَ عَفُوٌّ تُحِبُّ الْعَفْوَ فَاعْفُ عَنِّي', 'হে আল্লাহ! তুমি ক্ষমাশীল, তুমি ক্ষমা করতে ভালবাসো, তাই আমাকে ক্ষমা করো।', 0, 3),
('রোজার নিয়ত', 'نَوَيْتُ أَنْ أَصُومَ غَدًا لِلَّهِ تَعَالَى مِنْ فَرْضِ رَمَضَانَ', 'আমি আল্লাহ তায়ালার সন্তুষ্টির জন্য রমযানের ফরজ রোজা রাখার নিয়ত করলাম।', 0, 4),
('তারাবীর দোয়া', 'سُبْحَانَ ذِي الْمُلْكِ وَالْمَلَكُوتِ سُبْحَانَ ذِي الْعِزَّةِ وَالْعَظَمَةِ', 'পবিত্র সেই সত্তা যিনি রাজত্ব ও মহত্ত্বের মালিক।', 0, 5),
('কুনূতের দোয়া', 'اللَّهُمَّ اهْدِنَا فِيمَنْ هَدَيْتَ وَعَافِنَا فِيمَنْ عَافَيْتَ', 'হে আল্লাহ! তুমি যাদেরকে হিদায়াত দিয়েছ আমাদেরকেও হিদায়াত দাও।', 0, 6);

-- হাদীস
INSERT INTO hadith (arabic_text, bangla_translation, source, is_active) VALUES
('مَنْ صَامَ رَمَضَانَ إِيمَانًا وَاحْتِسَابًا غُفِرَ لَهُ مَا تَقَدَّمَ مِنْ ذَنْبِهِ', 'যে ব্যক্তি ঈমানের সাথে ও সওয়াবের আশায় রমযান মাসে রোযা রাখে, তার পূর্ববর্তী সকল গুনাহ ক্ষমা করে দেওয়া হয়।', 'সহীহ বুখারী ও মুসলিম', 1);

-- লোকেশন
INSERT INTO locations (city, country_code, latitude, longitude, calc_method, is_default) VALUES
('Selangor',     'MY', 3.073800,  101.518300, 3, 1),
('Kuala Lumpur', 'MY', 3.139000,  101.686900, 3, 0),
('Dhaka',        'BD', 23.810300,  90.412500, 1, 0),
('Chittagong',   'BD', 22.356900,  91.783200, 1, 0),
('Sylhet',       'BD', 24.894900,  91.868700, 1, 0),
('Rajshahi',     'BD', 24.374500,  88.604200, 1, 0),
('London',       'UK', 51.507400,  -0.127800,15, 0),
('New York',     'US', 40.712800, -74.006000, 2, 0),
('Dubai',        'UAE',25.204800,  55.270800, 4, 0),
('Riyadh',       'SA', 24.713600,  46.675300, 4, 0),
('Istanbul',     'TR', 41.008200,  28.978400,13, 0),
('Toronto',      'CA', 43.653200, -79.383200, 2, 0);

-- অ্যাডমিন (default: admin / ramadan2026)
-- password hash is bcrypt of "ramadan2026"
INSERT INTO admin_users (username, password_hash) VALUES
('admin', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi')
ON DUPLICATE KEY UPDATE username=username;
